/**********************************************************************************************
* Device      : AD18F08
* Author      : TANWENBO
* Version     : V0.0.1
* Date        : 2023.5.11
* Description : 演示配置LCD显示00 11 22 33 44 55 66 77 88 99
***********************************************************************************************/

/********************************INCLUDES*************************************/
#include <stdio.h>
#include <stdlib.h>
#include "AD18F08.h"
/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_OFF         :  使能LVR位
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见头文件；
************************************************************************************************/
__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L    & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                       );

/************************************************LCD****************************************/
//SEG
#define           SEG0                   PA3        //LCD的SEG3_选择PA3
#define           SEG1                   PB1        //LCD的SEG4_选择PB1
#define           SEG2                   PA5        //LCD的SEG1_选择PA5
#define           SEG3                   PA4        //LCD的SEG2_选择PA4



//COM
#define           COM0EN_PB5         COM0EN         //LCD的COM0_选择PB5(COM0EN)
#define           COM1EN_PB4         COM1EN         //LCD的COM1_选择PB4(COM1EN)
#define           COM2EN_PB3         COM2EN         //LCD的COM2_选择PB3(COM2EN)
#define           COM3EN_PB2         COM3EN         //LCD的COM3_选择PB2(COM3EN)
#define           COM4EN_PB1         COM4EN         //LCD的COM4_选择PB1(COM4EN)
#define           COM5EN_PB0         COM5EN         //LCD的COM5_选择PB0(COM5EN)
#define           COM6EN_PA0         COM6EN         //LCD的COM6_选择PA0(COM6EN)
#define           COM7EN_PA1         COM7EN         //LCD的COM7_选择PA1(COM7EN)
#define           COM8EN_PA2         COM8EN         //LCD的COM8_选择PA2(COM8EN)
#define           COM9EN_PA3         COM9EN         //LCD的COM9_选择PA3(COM9EN)
#define           COM10EN_PA4        COM10EN        //LCD的COM10_选择PA4(COM10EN)
#define           COM11EN_PA5        COM11EN        //LCD的COM11_选择PA5(COM11EN)
#define           COM12EN_PB6        COM12EN        //LCD的COM12_选择PB6(COM12EN)
#define           COM13EN_PB7        COM13EN        //LCD的COM13_选择PB7(COM13EN)

#define           Ele_100uA_5V            0         //LCD驱动电流选择100uA(VDD = 5V0)
#define           Ele_200uA_5V            1         //LCD驱动电流选择200uA(VDD = 5V0)
#define           Ele_400uA_5V            2         //LCD驱动电流选择400uA(VDD = 5V0)
#define           Ele_800uA_5V            3         //LCD驱动电流选择800uA(VDD = 5V0)

#define           LCD_ENABLE              0         //禁用LCD
#define           LCD_DISABLE             1         //使能LCD

volatile unsigned char DAT[10] = {0xFC,0x60,0xDA,0xF2,0x66,0xB6,0xBE,0xE0,0xFE,0xF6}; //显示断码
/************************************************LCD****************************************/


volatile unsigned char	USART_BUF @0x80;
volatile bit D0			@ ((unsigned)&USART_BUF*8)+0;
volatile bit D1			@ ((unsigned)&USART_BUF*8)+1;
volatile bit D2			@ ((unsigned)&USART_BUF*8)+2;
volatile bit D3			@ ((unsigned)&USART_BUF*8)+3;
volatile bit D4			@ ((unsigned)&USART_BUF*8)+4;
volatile bit D5			@ ((unsigned)&USART_BUF*8)+5;
volatile bit D6			@ ((unsigned)&USART_BUF*8)+6;
volatile bit D7			@ ((unsigned)&USART_BUF*8)+7;

#define     TX_DIR       TRISA0
#define     TX_PIN       PA0

#define     RX_DIR       TRISB0
#define     RX_PIN       PINB0

void putch(unsigned char byte)
{
	USART_BUF = byte;
	unsigned char i=0;
	TX_PIN = 1;
	TX_PIN = 0;
	__delay_us(104);
	for(i=0;i<8;i++)
	{
		TX_PIN = byte & 0X01;
		__delay_us(100);
		byte = byte>>1;
	}
	TX_PIN = 1;
	__delay_us(104);
	__delay_us(104);
}

unsigned char getch()
{
	unsigned char  tmp      = 0;
    unsigned char  Time_out = 250;

	__delay_us(104);
	__delay_us(52);
	if (RX_PIN==1)
		tmp = tmp | 0x01;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x02;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x04;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x08;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x10;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x20;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x40;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x80;
	__delay_us(104);

	if (RX_PIN==1)
		return tmp;
	else
		return 0;
}

//==============================================================================================
// ----Function: LCD设置
// --Parameters:
//           [LCD_Ele_Cfg]:
//               Ele_100uA_5V:LCD驱动电路设置为100uA
//               Ele_200uA_5V:LCD驱动电路设置为200uA
//               Ele_400uA_5V:LCD驱动电路设置为400uA
//               Ele_800uA_5V:LCD驱动电路设置为800uA
//           [LCD_Cfg]:
//               LCD_ENABLE  : 使能LCD
//               LCD_DISABLE : 禁用LCD
// -----Returns: None
//---------Note: COM端口和SEG端口的I/O需查询手册
//==============================================================================================
void LCD_Config(unsigned char LCD_Ele_Cfg,unsigned char LCD_Cfg)
{
         if(LCD_Ele_Cfg == Ele_100uA_5V){LCDCSEL1 = 0;LCDCSEL0 = 0;}
	else if(LCD_Ele_Cfg == Ele_200uA_5V){LCDCSEL1 = 0;LCDCSEL0 = 1;}
	else if(LCD_Ele_Cfg == Ele_400uA_5V){LCDCSEL1 = 1;LCDCSEL0 = 0;}
	else if(LCD_Ele_Cfg == Ele_800uA_5V){LCDCSEL1 = 1;LCDCSEL0 = 1;}
	else {LCDCSEL1 = 0;LCDCSEL0 = 0;}

	     if(LCD_Cfg == LCD_ENABLE)LCDCON0 |= 0x80;
	else if(LCD_Cfg == LCD_DISABLE)LCDCON0 = 0x00;
    else LCDCON0 = 0x00;

    printf("LCDCON0 = 0x%02X;",LCDCON0);
    printf("LCDCON1 = 0x%02X;",LCDCON1);
    printf("LCDCON2 = 0x%02X;",LCDCON2);
}

//==============================================================================================
// ----Function: TN反射段码液晶屏GDC02693驱动函数、有两个数字和一个小数点、超小尺寸、1/4D,1/2B
// --Parameters: None
// -----Returns: None
//---------Note: 接线方式
//               COM1_PB1、COM2_PB0、COM3_PB3、COM4_PB4
//               SEG1_PC2、SEG2_PC3、SEG3_PC4、SEG4_PC5
//               GDC02693资料:
//               http://www.good-display.cn/products_detail/productId=385.html
//               产品规格书:
//               http://www.good-display.cn/download_detail/downloadsId=734.html
//               某宝连接:
//               https://item.taobao.com/item.htm?spm=a1z0d.6639537.1997196601.4.72937484Dt1tOK&id=569740678436
//==============================================================================================
unsigned int i=600;
unsigned int a=30;
unsigned int b=50;
unsigned int c=5;

#define           COM0EN_PB5         COM0EN         //LCD的COM0_选择PB5(COM0EN)
#define           COM1EN_PB4         COM1EN         //LCD的COM1_选择PB4(COM1EN)
#define           COM2EN_PB3         COM2EN         //LCD的COM2_选择PB3(COM2EN)
#define           COM3EN_PB2         COM3EN         //LCD的COM3_选择PB2(COM3EN)
void LCD_Display(unsigned char temp1,unsigned char temp2)
{
	COM0EN_PB5  = 1;
	COM1EN_PB4  = 1;
	COM2EN_PB3  = 1;
	COM3EN_PB2  = 1;
	SEG2        = 0;
	SEG3        = 0;
	SEG0        = 0;
	SEG1        = 0;
	__delay_us(i);
	COM0EN_PB5  = 0;
	TRISB5      = 0;
	PB5         = 1;
	if((temp1>>2) & 0x01)SEG2 = 0;else SEG2 = 1;
	if((temp1>>7) & 0x01)SEG3 = 0;else SEG3 = 1;
	if((temp2>>2) & 0x01)SEG0 = 0;else SEG0 = 1;
	if((temp2>>7) & 0x01)SEG1 = 0;else SEG1 = 1;
	__delay_us(a);
	SEG2        = 0;
	SEG3        = 0;
	SEG0        = 0;
	SEG1        = 0;	__delay_us(c);
	PB5         = 0;
	if((temp1>>2) & 0x01)SEG2 = 1;else SEG2 = 0;
	if((temp1>>7) & 0x01)SEG3 = 1;else SEG3 = 0;
	if((temp2>>2) & 0x01)SEG0 = 1;else SEG0 = 0;
	if((temp2>>7) & 0x01)SEG1 = 1;else SEG1 = 0;
	__delay_us(b);


	COM0EN_PB5  = 1;
	COM1EN_PB4  = 1;
	COM2EN_PB3  = 1;
	COM3EN_PB2  = 1;
	SEG2        = 0;
	SEG3        = 0;
	SEG0        = 0;
	SEG1        = 0;
	__delay_us(i);
	COM1EN_PB4  = 0;
	TRISB4      = 0;
	PB4         = 1;
	if((temp1>>1) & 0x01)SEG2 = 0;else SEG2 = 1;
	if((temp1>>6) & 0x01)SEG3 = 0;else SEG3 = 1;
	if((temp2>>1) & 0x01)SEG0 = 0;else SEG0 = 1;
	if((temp2>>6) & 0x01)SEG1 = 0;else SEG1 = 1;
	__delay_us(a);
	SEG2        = 0;
	SEG3        = 0;
	SEG0        = 0;
	SEG1        = 0;__delay_us(c);
	PB4         = 0;
	if((temp1>>1) & 0x01)SEG2 = 1;else SEG2 = 0;
	if((temp1>>6) & 0x01)SEG3 = 1;else SEG3 = 0;
	if((temp2>>1) & 0x01)SEG0 = 1;else SEG0 = 0;
	if((temp2>>6) & 0x01)SEG1 = 1;else SEG1 = 0;
	__delay_us(b);


	COM0EN_PB5  = 1;
	COM1EN_PB4  = 1;
	COM2EN_PB3  = 1;
	COM3EN_PB2  = 1;
	SEG2        = 0;
	SEG3        = 0;
	SEG0        = 0;
	SEG1        = 0;
	__delay_us(i);
    COM2EN_PB3  = 0;
	TRISB3      = 0;
	PB3         = 1;
	if((temp1>>3) & 0x01)SEG2 = 0;else SEG2 = 1;
	if((temp1>>5) & 0x01)SEG3 = 0;else SEG3 = 1;
	if((temp2>>3) & 0x01)SEG0 = 0;else SEG0 = 1;
	if((temp2>>5) & 0x01)SEG1 = 0;else SEG1 = 1;
	__delay_us(a);
	SEG2        = 0;
	SEG3        = 0;
	SEG0        = 0;
	SEG1        = 0;__delay_us(c);
	PB3         = 0;
    if((temp1>>3) & 0x01)SEG2 = 1;else SEG2 = 0;
    if((temp1>>5) & 0x01)SEG3 = 1;else SEG3 = 0;
    if((temp2>>3) & 0x01)SEG0 = 1;else SEG0 = 0;
	if((temp2>>5) & 0x01)SEG1 = 1;else SEG1 = 0;
	__delay_us(b);


	COM0EN_PB5  = 1;
	COM1EN_PB4  = 1;
	COM2EN_PB3  = 1;
	COM3EN_PB2  = 1;
	SEG2        = 0;
	SEG3        = 0;
	SEG0        = 0;
	SEG1        = 0;
	__delay_us(i);
	COM3EN_PB2  = 0;
	TRISB2      = 0;
	PB2         = 1;
	SEG2        = 1;
	if((temp1>>4) & 0x01)SEG3 = 0;else SEG3 = 1;
	if((temp2>>0) & 0x01)SEG0 = 0;else SEG0 = 1;
	if((temp2>>4) & 0x01)SEG1 = 0;else SEG1 = 1;
	__delay_us(a);
	SEG2        = 0;
	SEG3        = 0;
	SEG0        = 0;
	SEG1        = 0;__delay_us(c);
	PB2         = 0;
	SEG2        = 0;
	if((temp1>>4) & 0x01)SEG3 = 1;else SEG3 = 0;
	if((temp2>>0) & 0x01)SEG0 = 1;else SEG0 = 0;
	if((temp2>>4) & 0x01)SEG1 = 1;else SEG1 = 0;
	__delay_us(2+100);
}

void main(void)
{
	unsigned int aa = 0;
	unsigned int bb = 0;
	unsigned int cc = 0;

    TRISA      = 0xC6;
    TRISB      = 0xED;
    CLKCFG1    = 0xFF;

    PA0        = 1;

    //LCD初始化设置   驱动电流设置为800uA      使能LCD模块
    LCD_Config(          Ele_800uA_5V,          LCD_ENABLE);

	while(1)
	{
	   aa++;
	   if(aa>20){bb++;aa=0;if(bb>10){cc++;bb=0;if(cc>9)cc=0;}}
       LCD_Display(DAT[cc],DAT[cc]);   //LCD扫描驱动
	}
}

//高优先级中断服务函数

void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断



}

//低优先级中断服务函数

void interrupt low_priority ISR_l (void)
{


}

